% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbtw_seasons.R
\name{nbtw_seasons}
\alias{nbtw_seasons}
\title{Number of detected animals between two sampling seasons}
\usage{
nbtw_seasons(
  animal_id,
  capture_date,
  season1_start,
  season1_end,
  season2_start,
  season2_end
)
}
\arguments{
\item{animal_id}{A column in the dataframe of all samples that stores
individual animal identifier code.}

\item{capture_date}{A column in the dataframe of all samples that stores
the date of sample collection. Must be in \code{Date} format.}

\item{season1_start}{String in \code{Date} format. Start of fist capture season.
Start and end date are included in the capture season.}

\item{season1_end}{String in \code{Date} format. End of fist capture season.
Start and end date are included in the capture season.}

\item{season2_start}{String in \code{Date} format. Start of second capture season.
Start and end date are included in the capture season.}

\item{season2_end}{String in \code{Date} format. End of second capture season.
Start and end date are included in the capture season.}
}
\value{
A data frame with one row and six columns corresponding to season 1 and 2
start and end dates, number of detected animals in season 2 (\code{total_cap}),
number of new detentions in season 2 (\code{new_captures}), umber of animals from
season 1 detected within season 2 (\code{recaptured}) and number of individuals
skipped in season 2 but detected after the end of that season (\code{skipped}).
}
\description{
Gives an numeric overview of individuals captured
within the second sampling season compared tho the first one.
}
\examples{
# Calculate the number of animals detected between two sampling seasons.
nbtw_seasons(
 animal_id = wolf_samples$AnimalRef,
 capture_date = wolf_samples$Date,
 season1_start = as.Date("2017-01-01"),
 season1_end = as.Date("2017-12-31"),
 season2_start = as.Date("2018-01-01"),
 season2_end = as.Date("2018-12-31")
)



}
