% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ped.R
\name{get_ped}
\alias{get_ped}
\title{Organizes pedigree data}
\usage{
get_ped(ped, sampledata, out = "FamAgg")
}
\arguments{
\item{ped}{Data frame. Pedigree data frame with the most basic structure.
Three columns corresponding to offspring, father and mother (see
Details). Unknown parents should be represented by \code{NA} values.}

\item{sampledata}{Data frame. Metadata for all genetic samples that belong
to the individuals included in pedigree reconstruction analysis.
This data frame should adhere to the formatting and naming conventions
outlined in the \code{\link[=check_sampledata]{check_sampledata()}} documentation.}

\item{out}{Character string. For use with which package should the output be formatted?
\code{kinship2} (out = "kinship2"), \code{pedtools} (out = "pedtools") or
\code{FamAgg} (out = "FamAgg") or the created data.frame can be outputted as is
(out = "table"). Defaults to "FamAgg"}
}
\value{
A data frame describing a common pedigree structure. Each individual included in
pedigree represents one row. Columns describe individual identifier code, identifier code for
mother and father and sex of individual. Column names and arrangement depends on selected
output (\code{out} parameter).
}
\description{
Offers an alternative to \code{\link[=get_colony]{get_colony()}} function in cases where the pedigree
was not reconstructed with \href{https://www.zsl.org/about-zsl/resources/software/colony}{COLONY}
software. It takes a pedigree dataframe and assigns sex to each individual.
The function also prepares data so that the output of the function can be directly analyzed with
\href{https://cran.r-project.org/package=kinship2}{\code{kinship2}},
\href{https://cran.r-project.org/package=pedtools}{\code{pedtools}} or
\href{https://bioconductor.org/packages/FamAgg/}{\code{FamAgg}} packages.
}
\details{
The custom pedigree specified through the \code{ped} parameter should mirror the
structure of a COLONY pedigree and share the same column names.
It should consist of three columns for each offspring:
\code{OffspringID}, \code{FatherID}, \code{MotherID}. When considering
unknown parents they should be represented by \code{NA} values.
}
\examples{
#example pedigree dataframe
ped <- data.frame(
  OffspringID = c(
    "M273P", "M20AM", "M2757", "M2ALK", "M2ETE", "M2EUJ", "MSV00E",
    "MSV018", "MSV05L", "MSV0M6", "MSV0T4", "MSV0T7", "MSV0TJ", "MSV0UL"
  ),
  FatherID = c(
    NA, NA, "M20AM", "M20AM", "M20AM", "M20AM", "M20AM",
    "M20AM", "M20AM", "M20AM", "M20AM", "M20AM", "M20AM", "M20AM"
  ),
  MotherID = c(
    NA, NA, "M273P", "M273P", "M273P", "M273P", "M273P",
    "M273P", "M273P", "M273P", "M273P", "M273P", "M273P", "M273P"
  )
)
#Get pedigree data in FamAgg format
get_ped(
    ped = ped,
    sampledata = wolf_samples
    )

}
