% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_colony.R
\name{get_colony}
\alias{get_colony}
\title{Organizes COLONY output}
\usage{
get_colony(
  colony_project_path,
  sampledata,
  rm_obsolete_parents = TRUE,
  out = "FamAgg"
)
}
\arguments{
\item{colony_project_path}{Character string. Path to the folder where COLONY output files are saved.
Has to include file path and project name (see Details).}

\item{sampledata}{Data frame. Metadata for all genetic samples that belong
to the individuals included in pedigree reconstruction analysis.
This data frame should adhere to the formatting and naming conventions
outlined in the \code{\link[=check_sampledata]{check_sampledata()}} documentation.}

\item{rm_obsolete_parents}{Logical. Should unknown parents be removed from output.
Applies just to offspring for which both parents are unknown. Defaults to \code{TRUE}.}

\item{out}{Character string. For use with which package should the output be formatted?
\code{kinship2} (out = "kinship2"), \code{pedtools} (out = "pedtools"),
\code{FamAgg} (out = "FamAgg") or the created data.frame can be outputted as is
(out = "table"). Defaults to "FamAgg"}
}
\value{
A data frame describing a common pedigree structure. Each individual included in
pedigree represents one row. Columns describe individual identifier code, identifier code for
mother and father, sex and family of individual. Column names and arrangement depends on selected
output (\code{out} parameter).
}
\description{
Extends \code{BestConfig_Ordered} output from \href{https://www.zsl.org/about-zsl/resources/software/colony}{COLONY}
pedigree reconstruction software with additional data about individuals included
in pedigree. The function adds missing parents to \code{OffspringID}, assigns
sex to each individual included in \code{OffspringID} and adds the computed
probabilities of paternity and maternity assignments (probability of assignments is visible
only if the \code{out} parameter is set to \code{"table"}).
The function also prepares data so that the output of the function can be directly analyzed with
\href{https://cran.r-project.org/package=kinship2}{\code{kinship2}},
\href{https://cran.r-project.org/package=pedtools}{\code{pedtools}} or
\href{https://bioconductor.org/packages/FamAgg/}{\code{FamAgg}} packages.
}
\details{
COLONY output tables needed for this function (\code{.BestConfig_Ordered},
\code{.Maternity} and \code{.Paternity}) are read directly
from the colony output folder and do not need to be imported into R session.
The path to the outputs is defined with \code{colony_project_path} parameter.
When defining \code{colony_project_path} the user needs to define a complete path to
the directory where colony outputs are stored and also the file name
(file name of COLONY outputs equals the project name \cr
eg. /path/to/the/COLONY/output/folder/COLONY_project_name).
}
\examples{
# Define the path to COLONY output
path <- paste0(system.file("extdata", package = "wpeR"), "/wpeR_samplePed")

# Get pedigree data in FamAgg format
get_colony(
    colony_project_path = path,
    sampledata = wolf_samples
    )



}
