% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workpatterns_report.R
\name{workpatterns_report}
\alias{workpatterns_report}
\title{Generate a report on working patterns in HTML}
\usage{
workpatterns_report(
  data,
  hrvar = "Organization",
  signals = c("email", "IM"),
  start_hour = "0900",
  end_hour = "1700",
  exp_hours = NULL,
  path = "workpatterns report",
  timestamp = TRUE
)
}
\arguments{
\item{data}{A Hourly Collaboration Query dataset in the form of a data frame.}

\item{hrvar}{String specifying HR attribute to cut by archetypes. Defaults to
\code{Organization}.}

\item{signals}{See \code{workpatterns_classify()}.}

\item{start_hour}{See \code{workpatterns_classify()}.}

\item{end_hour}{See \code{workpatterns_classify()}.}

\item{exp_hours}{See \code{workpatterns_classify()}.}

\item{path}{Pass the file path and the desired file name, \emph{excluding the file
extension}. For example, \code{"scope report"}.}

\item{timestamp}{Logical vector specifying whether to include a timestamp in
the file name. Defaults to TRUE.}
}
\value{
An HTML report with the same file name as specified in the arguments is
generated in the working directory. No outputs are directly returned by the
function.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function takes a Hourly Collaboration query and generates a HTML report
on working patterns archetypes. Archetypes are created using the binary-week
method.
}
\seealso{
Other Reports: 
\code{\link{IV_report}()},
\code{\link{capacity_report}()},
\code{\link{coaching_report}()},
\code{\link{collaboration_report}()},
\code{\link{connectivity_report}()},
\code{\link{generate_report}()},
\code{\link{meeting_tm_report}()},
\code{\link{read_preamble}()},
\code{\link{subject_validate_report}()},
\code{\link{validation_report}()}

Other Working Patterns: 
\code{\link{flex_index}()},
\code{\link{identify_shifts}()},
\code{\link{identify_shifts_wp}()},
\code{\link{plot_flex_index}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_classify}()},
\code{\link{workpatterns_classify_bw}()},
\code{\link{workpatterns_classify_pav}()},
\code{\link{workpatterns_hclust}()},
\code{\link{workpatterns_rank}()}
}
\concept{Reports}
\concept{Working Patterns}
