% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workpatterns_hclust.R
\name{workpatterns_hclust}
\alias{workpatterns_hclust}
\title{Create a hierarchical clustering of email or IMs by hour of day}
\usage{
workpatterns_hclust(
  data,
  k = 4,
  return = "plot",
  values = "percent",
  signals = "email",
  start_hour = "0900",
  end_hour = "1700"
)
}
\arguments{
\item{data}{A data frame containing data from the Hourly Collaboration query.}

\item{k}{Numeric vector to specify the \code{k} number of clusters to cut by.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"data"}
\item \code{"table"}
\item \code{"plot-area"}
\item \code{"hclust"}
\item \code{"dist"}
}

See \code{Value} for more information.}

\item{values}{Character vector to specify whether to return percentages
or absolute values in "data" and "plot". Valid values are:
\itemize{
\item "percent": percentage of signals divided by total signals (default)
\item "abs": absolute count of signals
}}

\item{signals}{Character vector to specify which collaboration metrics to use:
\itemize{
\item \code{"email"} (default) for emails only
\item \code{"IM"} for Teams messages only
\item \code{"unscheduled_calls"} for Unscheduled Calls only
\item \code{"meetings"} for Meetings only
\item or a combination of signals, such as \code{c("email", "IM")}
}}

\item{start_hour}{A character vector specifying starting hours,
e.g. "0900"}

\item{end_hour}{A character vector specifying starting hours,
e.g. "1700"}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: ggplot object of a bar plot (default)
\item \code{"data"}: data frame containing raw data with the clusters
\item \code{"table"}: data frame containing a summary table. Percentages of signals
are shown, e.g. x\% of signals are sent by y hour of the day.
\item \code{"plot-area"}: ggplot object. An overlapping area plot
\item \code{"hclust"}: \code{hclust} object for the hierarchical model
\item \code{"dist"}: distance matrix used to build the clustering model
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Apply hierarchical clustering to emails sent by hour of day.
The hierarchical clustering uses cosine distance and the ward.D method
of agglomeration.
}
\details{
The hierarchical clustering is applied on the person-average volume-based (pav) level.
In other words, the clustering is applied on a dataset where the collaboration hours
are averaged by person and calculated as \% of total daily collaboration.
}
\examples{
\donttest{
# Run clusters, returning plot
workpatterns_hclust(em_data, k = 5, return = "plot")

# Run clusters, return raw data
workpatterns_hclust(em_data, k = 4, return = "data") \%>\% head()

# Run clusters for instant messages only, return hclust object
workpatterns_hclust(em_data, k = 4, return = "hclust", signals = c("IM"))
}

}
\seealso{
Other Clustering: 
\code{\link{personas_hclust}()},
\code{\link{workpatterns_classify}()}

Other Working Patterns: 
\code{\link{flex_index}()},
\code{\link{identify_shifts}()},
\code{\link{identify_shifts_wp}()},
\code{\link{plot_flex_index}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_classify}()},
\code{\link{workpatterns_classify_bw}()},
\code{\link{workpatterns_classify_pav}()},
\code{\link{workpatterns_rank}()},
\code{\link{workpatterns_report}()}
}
\concept{Clustering}
\concept{Working Patterns}
