% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspace.R
\name{workspace_bind}
\alias{workspace_bind}
\title{Bind a Workspace into Another Workspace}
\usage{
workspace_bind(x, y, replace = FALSE)
}
\arguments{
\item{x}{the workspace where y elements will be copied}

\item{y}{the workspace to add to \code{x} workspace}

\item{replace}{scalar logical, set to TRUE if you want to
overwrite existing elements.}
}
\value{
workspace object resulting from bind operation.
}
\description{
Bind a workspace into another workspace.
}
\examples{
library(workspace)
x <- new_workspace()
x <- store_dataset(x = x, dataset = iris, name = "iris_dataset")
z <- new_workspace()
z <- store_dataset(x = z, dataset = mtcars, name = "mtcars")
json_str <- paste0("{\"first_name\": \"John\",\"last_name\": \"Smith\",\"is_alive\": true,",
"\"age\": 27, \"address\": { \"street_address\": \"21 2nd Street\",",
"\"city\": \"New York\",\"state\": \"NY\",\"postal_code\": \"10021-3100\"",
"}}")
z <- store_json(
  x = z,
  json_str = json_str,
  filename = "example.json",
  timestamp = "2023-11-12 11:37:41",
  subdir = "blah"
)
z <- store_rds(
  x = z,
  obj = mtcars,
  filename = "obj.rds",
  timestamp = "2023-11-12 11:37:41",
  subdir = "r-object"
)

new_x <- workspace_bind(x, z)
new_x
}
\seealso{
\link{workspace} for package documentation

Other functions to manage workspaces: 
\code{\link{new_workspace}()},
\code{\link{pack_workspace}()},
\code{\link{unpack_workspace}()},
\code{\link{workspace_copy}()}
}
\concept{functions to manage workspaces}
