#' Middle earth example coordinates
#'
#' @format A data frame with 100 rows and 2 columns
#' \describe{
#'   \item{x}{X coordinate.}
#'   \item{y}{Y coordinate.}
#' }
#' @source Created from simulations in Bishop et al. (2023).
"lotr_coords"

#' Middle earth example vcf
#'
#' A Variant Call Format data set
#'
#' @format Object of class vcfR with 100 individuals and 1000 loci.
#' @source Created from simulations in Bishop et al. (2023).
"lotr_vcf"

#' Middle earth example raster
#'
#' RasterLayer of middle earth based on an example digital elevation model of Tolkien's
#' Middle Earth produced by the Center for Geospatial Analysis at William & Mary
#' (Robert, 2020).
#'
#' @format RasterLayer.
#' @source Created from simulations in Bishop et al. (2023) based on Rose, Robert A. (2020) GIS & Middle Earth Presentation & Data Set. William & Mary. \doi{10.21220/RKEZ-X707}
#'
"lotr_lyr"

#' Middle earth example range polygon
#'
#' sf polygon of range map
#'
#'
#' @format sf.
#' @source Created from simulations in Bishop et al. (2023).
"lotr_range"


#' Mini middle earth example coordinates
#'
#' @format A data frame with 10 rows and 2 columns
#' \describe{
#'   \item{x}{X coordinate.}
#'   \item{y}{Y coordinate.}
#' }
#' @source Created from simulations in Bishop et al. (2023).
"mini_coords"

#' Mini middle earth example vcf
#'
#' A Variant Call Format data set
#'
#' @format Object of class vcfR with 10 individuals and 10 loci.
#' @source Created from simulations in Bishop et al. (2023).
"mini_vcf"

#' Mini middle earth example vcf with NA values
#'
#' A Variant Call Format data set with NA values
#'
#' @format Object of class vcfR with 10 individuals and 10 loci.
#' @source Created from simulations in Bishop et al. (2023).
"mini_vcf_NA"

#' Mini middle earth example raster
#'
#' Small RasterLayer of middle earth based on an example digital elevation model of Tolkien's
#' Middle Earth produced by the Center for Geospatial Analysis at William & Mary
#' (Robert, 2020).
#'
#' @format A RasterLayer of middle earth.
#' @source Created from simulations in Bishop et al. (2023) based on Rose, Robert A. (2020) GIS & Middle Earth Presentation & Data Set. William & Mary. \doi{10.21220/RKEZ-X707}
"mini_lyr"
