% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{normalizedTitle}
\alias{normalizedTitle}
\title{Return the normalized and redirect title from the response}
\usage{
normalizedTitle(title, q)
}
\arguments{
\item{title}{The title likely to be found in q.}

\item{q}{The query part of the JSON response (j['query']) from a Mediawiki
search. Note that this part contains some titles, so it is necessary to
search the original "title" in that part.}
}
\value{
A vector with the normalized or redirected page title (target, also
normalized) found for the title.
}
\description{
Return the normalized and the redirect title (also normalized), if any, from
the query part of the JSON response of a MediaWiki search. The response of
the MediaWiki API query (https://www.mediawiki.org/wiki/API:Query) includes
original page titles and possibily normalized and redirected titles, if the
API needs to obtain them. For a original title, this function returns them,
if any.
}
