% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_names.R
\name{add_item_prod_code}
\alias{add_item_prod_code}
\title{Get production item codes from item names}
\usage{
add_item_prod_code(
  table,
  name_column = "item_prod_name",
  code_column = "item_prod_code"
)
}
\arguments{
\item{table}{The table that will be modified with a new column.}

\item{name_column}{The name of the column in \code{table} containing the names.}

\item{code_column}{The name of the output column containing the codes.}
}
\value{
A tibble with all the contents of \code{table} and an extra column
named \code{code_column}, which contains the codes. If there is no code match,
an \code{NA} is included.
}
\description{
Add a new column to an existing tibble with the corresponding code
for each production item name. The codes are assumed to be from those
defined by FAOSTAT.
}
\examples{
table <- tibble::tibble(
  item_prod_name = c("Rice", "Cabbages", "Dummy Item")
)
add_item_prod_code(table)

table |>
  dplyr::rename(my_item_prod_name = item_prod_name) |>
  add_item_prod_code(name_column = "my_item_prod_name")

add_item_prod_code(table, code_column = "my_custom_code")
}
