% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{tab_metrics_one_cor}
\alias{tab_metrics_one_cor}
\title{Correlate two columns}
\usage{
tab_metrics_one_cor(
  data,
  col,
  cross,
  method = "pearson",
  ci = FALSE,
  digits = 2,
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble.}

\item{col}{The first column holding metric values.}

\item{cross}{The second column holding metric values.}

\item{method}{The output metrics, TRUE or pearson = Pearson's R, spearman = Spearman's rho}

\item{ci}{Whether to output confidence intervals.}

\item{digits}{The number of digits to print.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{tab_counts}.}
}
\value{
A volker tibble.
}
\description{
Correlate two columns
}
\examples{
library(volker)
data <- volker::chatgpt

tab_metrics_one_cor(data, use_private, sd_age)

}
\keyword{internal}
