% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect_counts_one_grouped}
\alias{effect_counts_one_grouped}
\title{Output test statistics and effect size for contingency tables}
\usage{
effect_counts_one_grouped(data, col, cross, clean = TRUE, ...)
}
\arguments{
\item{data}{A tibble.}

\item{col}{The column holding factor values.}

\item{cross}{The column holding groups to compare.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{effect_counts}.}
}
\value{
A volker list with two volker tibbles.
The first tibble contains npmi values for each combinations:
\itemize{
\item n Number the combination occurs.
\item p_x Marginal share of the first category.
\item p_y Marginal share of the second category.
\item p_xy Share of the combination based on all combinations.
\item ratio The ratio of p_xy to (p_x * p_y).
\item pmi Pointwise Mutual information, derived from the ratio.
\item npmi Normalized Pointwise Mutual Information, derived from the pmi.
}

The second tibble contains effect sizes based on the cross table:
\itemize{
\item Cramer's V: Effect size measuring the association between the two variables.
\item n: Number of cases the calculation is based on.
\item Chi-squared: Chi-Squared test statistic.
If expected values are below 5 in at least one cell, an exact Fisher test is conducted.
\item df: Degrees of freedo of the chi-squared test. Empty for the exact Fisher test.
\item p: p-value of the chi-squared test.
\item stars: Significance stars based on p-value (*, **, ***).
}
}
\description{
Chi squared is calculated using \code{stats::\link[stats:chisq.test]{chisq.test}}.
If any cell contains less than 5 observations, the exact-parameter is set.
}
\details{
Phi is derived from the Chi squared value by \code{sqrt(fit$statistic / n)}.
Cramer's V is derived by \code{sqrt(phi / (min(dim(contingency)[1], dim(contingency)[2]) - 1))}.
Cramer's V is set to 1.0 for diagonal contingency matrices, indicating perfect association.
}
\examples{
library(volker)
data <- volker::chatgpt

effect_counts_one_grouped(data, adopter, sd_gender)

}
\keyword{internal}
