% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed_media.R
\name{embed_audio}
\alias{embed_audio}
\title{These functions are sourced from the `embedr` package by Michael McCarthy, under
MIT License: https://github.com/mccarthy-m-g/embedr/blob/master/LICENSE.md
This inclusion is temporary and will be discontinued once `embedr` is available on CRAN.
See https://github.com/mccarthy-m-g/embedr for more details.}
\usage{
embed_audio(
  src,
  type = c("mpeg", "ogg", "wav"),
  attribute = c("controls", "autoplay", "loop", "muted", "preload", "none"),
  id = "",
  placeholder = ""
)
}
\arguments{
\item{src}{A path or URL to the media file.}

\item{type}{The type of media file specified in `src`.}

\item{attribute}{A character vector specifying which attributes to use.
"none" can be used if no attributes are desired.}

\item{id}{A character string specifying a unique ID for the element.
Can be used by CSS or JavaScript to perform certain tasks for
the element with the specific ID.}

\item{placeholder}{The placeholder text to use when the output format is
not HTML.}
}
\value{
If `knitr::is_html_output()` is `TRUE`, returns HTML `<audio>` code.
  If `knitr::is_html_output()` is `FALSE`, returns placeholder text.
}
\description{
Embed audio in R Markdown documents
}
\details{
`embed_audio()` provides a standard way to embed audio in R Markdown
documents when the output format is HTML, and to print placeholder text
when the output format is not HTML.

`embed_audio()` is a wrapper for the HTML5 `<audio>` element that prints
HTML `<audio>` code in HTML documents built by R Markdown and placeholder
text in non-HTML documents built by R Markdown. This function may be useful
for conditional output that depends on the output format. For example, you
may embed audio in an R Markdown document when the output format is HTML,
and print placeholder text when the output format is LaTeX.

The function determines output format using [knitr::is_html_output()]. By
default, these formats are considered as HTML formats: `c('markdown',
'epub', 'html', 'html5', 'revealjs', 's5', 'slideous', 'slidy')`.
}
\note{
This function is supposed to be used in R code chunks or inline R code
  expressions. You are recommended to use forward slashes (/) as path
  separators instead of backslashes in the file paths.
}
\examples{
# By default, embed_audio() embeds an audio element with playback controls
embed_audio(mp3)

# To change the attributes of the audio element, use `attribute`
embed_audio(mp3, attribute = c("controls", "loop"))

# To add placeholder text for non-HTML documents, use `placeholder`
embed_audio(mp3, placeholder = "This is placeholder text.")

\dontrun{
# embed_audio() is intended to be used in R Markdown code chunks or inline
# expressions. The following creates and knits an R Markdown document to
# HTML and PDF in your current working directory for you to inspect:
library(rmarkdown)
writeLines(c("# Hello embedr!",
"```{r embed-audio, echo=TRUE}",
"embed_audio(mp3, placeholder = 'This is placeholder text.')",
"```"), "test.Rmd")
render("test.Rmd", output_format = c('html_document', 'pdf_document'))

# Delete test files created by example code
unlink(c("test.Rmd", "test.html", "test.pdf"))
}
}
