% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmd.R
\name{read_hmd}
\alias{read_hmd}
\title{Read data directly from HMD and construct a \code{vital} object for use in other functions}
\usage{
read_hmd(
  country,
  username,
  password,
  variables = c("Deaths", "Exposures", "Population", "Mx")
)
}
\arguments{
\item{country}{Country name or country code as specified by the HMD. For instance, Australian
data can be obtained using \code{country = "Australia"} or \code{country = "AUS"}.}

\item{username}{HMD username (case-sensitive)}

\item{password}{HMD password (case-sensitive)}

\item{variables}{List of variables to download from the HMD. If the data
contains a mixture of age-specific and non-age-specific variables, then
the non-age-specific data will be repeated for each age.}
}
\value{
\code{read_hmd} returns a \code{vital} object combining the downloaded data.
}
\description{
\code{read_hmd} reads single-year and single-age data from the Human Mortality Database (HMD
\url{https://www.mortality.org}) and constructs a \code{vital} object suitable
for use in other functions. This function uses \code{\link[HMDHFDplus:readHMDweb]{HMDHFDplus::readHMDweb()}}
to download the required data. It is designed to handle Deaths, Population,
Exposure, Death Rates and Births. By default, Deaths, Population, Exposure
and Death Rates are downloaded. It is better to handle Births separately as
they are not age-specific.
}
\details{
In order to read the data, users are required to create an account with the
HMD website (\url{https://www.mortality.org}), and obtain a valid username and password.
}
\examples{
\dontrun{
norway <- read_hmd(
  country = "Norway",
  username = "Nora.Weigh@mymail.com",
  password = "FF!5xeEFa6"
)
norway_births <- read_hmd(
  country = "Norway",
  username = "Nora.Weigh@mymail.com",
  password = "FF!5xeEFa6",
  variables = "Births"
)
}
}
\author{
Rob J Hyndman
}
