% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_ages.R
\name{collapse_ages}
\alias{collapse_ages}
\title{Collapse upper ages into a single age group. Counts are summed while
rates are recomputed where possible.}
\usage{
collapse_ages(.data, max_age = 100)
}
\arguments{
\item{.data}{A vital object including an age variable}

\item{max_age}{Maximum age to include in the collapsed age group.}
}
\value{
A vital object with the same variables as \code{.data}, but with the upper
ages collapsed into a single age group.
}
\description{
Collapse upper ages into a single age group. Counts are summed while
rates are recomputed where possible.
}
\details{
If the object includes deaths,
population and mortality rates, then deaths and population are summed and
mortality rates are recomputed as deaths/population. But if the object contains
mortality rates but not deaths and population, then the last rate remains
unchanged (and a warning is generated).
}
\examples{
norway_mortality |>
  dplyr::filter(Sex == "Female") |>
  collapse_ages(max_age = 85)
}
\author{
Rob J Hyndman
}
