% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visGetUtils.R
\name{visGetConnectedNodes}
\alias{visGetConnectedNodes}
\title{Method getConnectedNodes, with shiny only.}
\usage{
visGetConnectedNodes(graph, id, input = paste0(graph$id, "_connectedNodes"))
}
\arguments{
\item{graph}{: a \code{ \link[visNetwork]{visNetworkProxy}}  object}

\item{id}{: a node or edge id}

\item{input}{: name of shiny input created. Default to paste0(graph$id, "_connectedNodes")}
}
\description{
Method getConnectedNodes, with shiny only. Returns a vector of nodeIds of the all the nodes that are directly connected to this node. If you supply an edgeId, vis will first match the id to nodes.
}
\examples{
\dontrun{

# have a look to : 
shiny::runApp(system.file("shiny", package = "visNetwork"))

}

}
\references{
See online documentation \url{https://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link[visNetwork]{visNodes} for nodes options,  \link[visNetwork]{visEdges} for edges options,  \link[visNetwork]{visGroups} for groups options, 
\link[visNetwork]{visLegend} for adding legend,  \link[visNetwork]{visOptions} for custom option,  \link[visNetwork]{visLayout} &  \link[visNetwork]{visHierarchicalLayout} for layout, 
\link[visNetwork]{visPhysics} for control physics,  \link[visNetwork]{visInteraction} for interaction,  \link[visNetwork]{visNetworkProxy} &  \link[visNetwork]{visFocus} &  \link[visNetwork]{visFit} for animation within shiny,
\link[visNetwork]{visDocumentation},  \link[visNetwork]{visEvents},  \link[visNetwork]{visConfigure} ...
}
