#' Driver A
#'
#' A vector of 5000 values (years) between 0 and 100 generated by \code{\link{simulateDriver}} with a temporal autocorrelation significant for 600 years. It is meant to be used as input for \code{\link{simulatePopulation}}.
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name driverA
#' @usage data(driverA)
#' @format Numeric vector of length 5000.
#' @seealso \code{\link{simulateDriver}}
"driverA"


#' Driver B
#'
#' A vector of 5000 values (years) between 0 and 100 generated by \code{\link{simulateDriver}} with a temporal autocorrelation significant for 600 years. It is meant to be used as input for \code{\link{simulatePopulation}}.
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name driverB
#' @usage data(driverB)
#' @format Numeric vector of length 5000.
#' @seealso \code{\link{simulateDriver}}
"driverB"


#' Drivers with different temporal autocorrelation.
#'
#' A dataframe with 20000 rows and 4 columns (years) containing two drivers (A and B) generated by \code{\link{simulateDriver}} with different temporal autocorrelations (200 and 600). Each driver represents a period of 5000 years. This dataset is is meant to be used as input for \code{\link{simulatePopulation}}
#'
#' \itemize{
#'   \item \emph{time} integer, represents time from 0 to 10000, \strong{where 0 is the oldest sample, and 10000 is the newest one (opposite to the general interpretation of age in palaeoecology!)}.
#'   \item \emph{driver} character, values are \code{A} and \code{B}
#'   \item \emph{autocorrelation.length} numeric, values are 200, 600, and 1800.
#'   \item \emph{value} numeric, value of the driver for the given \code{time}, \emph{driver}, and \emph{autocorrelation.length}.
#' }
#'
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name drivers
#' @usage data(drivers)
#' @format Dataframe with 4 columns and 20000 rows.
#' @seealso \code{\link{simulateDriver}}
"drivers"


#' Parameters of 4 virtual taxa.
#'
#' A dataframe with the parameters of 4 virtual taxa. This dataset was generated by \code{\link{parametersDataframe}} and \code{\link{fixParametersTypes}}. It is meant to be used as input for \code{\link{simulatePopulation}}. Its columns are:
#'
#' \itemize{
#'   \item \emph{label}: to store names (character string) of the virtual taxa.
#'   \item \emph{maximum.age}: integer, maximum possible age of the individuals in years.
#'   \item \emph{reproductive.age}: integer, age of sexual maturity in years.
#'   \item \emph{fecundity}: integer, number of maximum viable seeds produced by a mature individual under fully suitable conditions.
#'   \item \emph{growth.rate}: numeric, parameter of the logistic growth function.
#'   \item \emph{pollen.control}: numeric in the interval [0, 1]. If 0, pollen productivity depends on environmental suitability only. The larger the number, biomass takes over environmental suitability in determining pollen productivity.
#'   \item \emph{maximum.biomass}: integer, maximum biomass of the individuals.
#'   \item \emph{carrying.capacity}: integer, maximum sum of biomass of the individuals. Very large carrying capacities plus a low maximum.biomass generates too many individuals for the simulation to remain efficient. Try to set carrying.capacity and maximum.biomass to carrying.capacity divided by biomass returns a number lower than 1000 (and even better if it is closer to 100).
#'   \item \emph{driver.A.weight}: numeric in the interval [0, 1], represents the relative influence of the driver on environmental suitability.
#'   \item \emph{driver.B.weight}: numeric in the interval [0, 1], represents the relative influence of the driver on environmental suitability. The sum of weights of drivers A and B should be 1.
#'   \item \emph{niche.A.mean}: numeric, in the same units as driver A. It is the mean of the normal function defining the response of the virtual taxa to driver A.
#'   \item \emph{niche.A.sd}: numeric, in the same units as driver A. It is the standard deviation of the normal function defining the response of the virtual taxa to driver A.
#'   \item \emph{niche.B.mean}: as above, but for driver B.
#'   \item \emph{niche.B.sd}: as above, but for driver B.
#'   \item \emph{autocorrelation.length.A}: numeric, only useful if several drivers generated with different autocorrelation lengths are available (and identified by the column \code{autocorrelation.length}) in the \code{drivers} argument provided to the \code{\link{simulatePopulation}} function.
#'   \item \emph{autocorrelation.length.B}: same as above.
#' }
#'
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name parameters
#' @usage data(parameters)
#' @format Dataframe with 16 columns and 4 rows.
#' @seealso \code{\link{parametersCheck}}, \code{\link{parametersDataframe}}, \code{\link{simulatePopulation}}
"parameters"


#' List with simulation outputs for all virtual taxa in \code{\link{parameters}}.
#'
#' A list of dataframes with 4 slots, output of \code{\link{simulatePopulation}}, taking \code{\link{parameters}} and \code{\link{drivers}} as inputs. Each dataframe in the list has the following columns:
#'
#' \itemize{
#'   \item \emph{Time}: integer, ages in years. Negative ages indicate the burn-in period.
#'   \item \emph{Pollen}: numeric, pollen counts
#'   \item \emph{Population.mature}: numeric, number of mature individuals.
#'   \item \emph{Population.immatre}: numeric, number of immature individuals.
#'   \item \emph{Population.viable.seeds}: numeric, number of viable seeds generated each year.
#'   \item \emph{Suitability}: numeric, environmental suitability computed from the driver by the normal function/s defining the taxon niche.
#'   \item \emph{Biomass.total}: numeric, overall biomass of the population.
#'   \item \emph{Biomass.mature}: numeric, sum of biomass of mature individuals.
#'   \item \emph{Biomass.immature}: numeric, sum of biomass of immature individuals.
#'   \item \emph{Mortality.mature}: numeric, number of mature individuals dead each year.
#'   \item \emph{Mortality.immature}: numeric, same as above for immature individuals.
#'   \item \emph{Driver.A}: numeric, values of driver A.
#'   \item \emph{Driver.B}: numeric, values of driver B, if available, and NA otherwise.
#'   \item \emph{Period}: qualitative, with value "Burn-in" for burn-in period, and "Simulation" otherwise.
#' }
#'
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name simulation
#' @usage data(simulation)
#' @format List with 4 dataframes with outputs of \code{\link{simulatePopulation}}.
#' @seealso \code{\link{simulatePopulation}}, \code{\link{plotSimulation}}
"simulation"


#' Accumulation rate
#'
#' Dataframe, output of \code{\link{simulateAccumulationRate}}.
#' @author Blas M. Benito  <blasbenito@gmail.com>
#' @docType data
#' @keywords datasets
#' @name accumulationRate
#' @usage data(accumulationRate)
#' @format Dataframe with 5000 rows and the following columns:
#' #' @return A dataframe with the following columns.
#' \itemize{
#'   \item \emph{time}: numeric, time or age of the given case.  \strong{Important}: the \code{time} column goes from "left to right", meaning that oldest samples have the lowest values of age/time, and viceversa.
#'   \item \emph{accumulation.rate}: numeric, in years per centimetre, simulated accumulation rate.
#'   \item \emph{grouping}: integer, grouping variable to aggregate together (with \code{\link{aggregateSimulation}}) samples deposited in the same centimetre according \emph{accumulation.rate}.
#' }
#' @seealso \code{\link{simulateAccumulationRate}}, \code{\link{aggregateSimulation}}
"accumulationRate"

#' @import ggplot2 viridis tidyr plyr stats
NULL

#' @importFrom mgcv gam
NULL

#' @importFrom grDevices dev.off pdf
NULL

#' @import utils
utils::globalVariables(c("Variable", "Value", "Time", "Species", "Suitability", "Driver.density.y", "Driver.weights", "Fecundity", "Age", "Biomass", "Reproductive.age", "ci.max", "ci.min", "Time", "Color", "error", "value", "..scaled..", "driver.A.weight", "maximum.biomass", "growthrate", "carrying.capacity", "fecundity", "pollen.control", "growth.rate"))


