% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TxtWithImagesComparator.R
\name{TxtWithImagesFileComparator}
\alias{TxtWithImagesFileComparator}
\title{TxtWithImageFileComparator.R}
\description{
TxtWithImageFileComparator.R

TxtWithImageFileComparator.R
}
\details{
"Abstract"  comparator for txt based comparator classes that can additionally
contain embedded images. This abstraction level contains generic logic for
handling embedded images and storing the related data.
}
\section{Super classes}{
\code{\link[verifyr2:FileComparator]{verifyr2::FileComparator}} -> \code{\link[verifyr2:BinaryFileComparator]{verifyr2::BinaryFileComparator}} -> \code{\link[verifyr2:TxtFileComparator]{verifyr2::TxtFileComparator}} -> \code{TxtWithImagesFileComparator}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{file1_images_raw}}{local property for storing image1 raw data}

\item{\code{file2_images_raw}}{local property for storing image2 raw data}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TxtWithImagesFileComparator-new}{\code{TxtWithImagesFileComparator$new()}}
\item \href{#method-TxtWithImagesFileComparator-vrf_summary_inner}{\code{TxtWithImagesFileComparator$vrf_summary_inner()}}
\item \href{#method-TxtWithImagesFileComparator-vrf_details_inner}{\code{TxtWithImagesFileComparator$vrf_details_inner()}}
\item \href{#method-TxtWithImagesFileComparator-vrf_images}{\code{TxtWithImagesFileComparator$vrf_images()}}
\item \href{#method-TxtWithImagesFileComparator-hex2raw}{\code{TxtWithImagesFileComparator$hex2raw()}}
\item \href{#method-TxtWithImagesFileComparator-clone}{\code{TxtWithImagesFileComparator$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_add_debug"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_add_debug'><code>verifyr2::FileComparator$vrf_add_debug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_add_debug_files"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_add_debug_files'><code>verifyr2::FileComparator$vrf_add_debug_files()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_close_debug"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_close_debug'><code>verifyr2::FileComparator$vrf_close_debug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_details"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_details'><code>verifyr2::FileComparator$vrf_details()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_open_debug"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_open_debug'><code>verifyr2::FileComparator$vrf_open_debug()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_option_value"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_option_value'><code>verifyr2::FileComparator$vrf_option_value()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="FileComparator" data-id="vrf_summary"><a href='../../verifyr2/html/FileComparator.html#method-FileComparator-vrf_summary'><code>verifyr2::FileComparator$vrf_summary()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="BinaryFileComparator" data-id="vrf_contents"><a href='../../verifyr2/html/BinaryFileComparator.html#method-BinaryFileComparator-vrf_contents'><code>verifyr2::BinaryFileComparator$vrf_contents()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="TxtFileComparator" data-id="vrf_contents_inner"><a href='../../verifyr2/html/TxtFileComparator.html#method-TxtFileComparator-vrf_contents_inner'><code>verifyr2::TxtFileComparator$vrf_contents_inner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="verifyr2" data-topic="TxtFileComparator" data-id="vrf_details_supported"><a href='../../verifyr2/html/TxtFileComparator.html#method-TxtFileComparator-vrf_details_supported'><code>verifyr2::TxtFileComparator$vrf_details_supported()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TxtWithImagesFileComparator-new"></a>}}
\if{latex}{\out{\hypertarget{method-TxtWithImagesFileComparator-new}{}}}
\subsection{Method \code{new()}}{
Initialize a TxtWithImagesFileComparator instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TxtWithImagesFileComparator$new(file1 = NULL, file2 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file1}}{First file to compare.}

\item{\code{file2}}{Second file to compare.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TxtWithImagesFileComparator-vrf_summary_inner"></a>}}
\if{latex}{\out{\hypertarget{method-TxtWithImagesFileComparator-vrf_summary_inner}{}}}
\subsection{Method \code{vrf_summary_inner()}}{
Method for comparing the inner part for the details query. This method
can be overwritten by more specialized comparator classes. This method is
intended to be called only by the comparator classes in the processing
and shouldn't be called directly by the user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TxtWithImagesFileComparator$vrf_summary_inner(config, omit)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{configuration values}

\item{\code{omit}}{string pattern to omit from the comparison}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TxtWithImagesFileComparator-vrf_details_inner"></a>}}
\if{latex}{\out{\hypertarget{method-TxtWithImagesFileComparator-vrf_details_inner}{}}}
\subsection{Method \code{vrf_details_inner()}}{
Method for comparing the inner part for the details query. This method
can be overwritten by more specialized comparator classes. This method is
intended to be called only by the comparator classes in the processing
and shouldn't be called directly by the user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TxtWithImagesFileComparator$vrf_details_inner(config, omit)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{configuration values}

\item{\code{omit}}{string pattern to omit from the comparison}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TxtWithImagesFileComparator-vrf_images"></a>}}
\if{latex}{\out{\hypertarget{method-TxtWithImagesFileComparator-vrf_images}{}}}
\subsection{Method \code{vrf_images()}}{
"Abstract" method for getting the raw image hex vector array from the
given source file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TxtWithImagesFileComparator$vrf_images(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{file for which to get the embedded image details}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TxtWithImagesFileComparator-hex2raw"></a>}}
\if{latex}{\out{\hypertarget{method-TxtWithImagesFileComparator-hex2raw}{}}}
\subsection{Method \code{hex2raw()}}{
Internal helper method for converting a hex string to raw vector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TxtWithImagesFileComparator$hex2raw(hex_string)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hex_string}}{hexadecimal string to be converted to raw vector}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TxtWithImagesFileComparator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TxtWithImagesFileComparator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TxtWithImagesFileComparator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
