% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_juice.R
\name{write_juice}
\alias{write_juice}
\alias{write_juice,vegtable,character,formula-method}
\alias{read_juice}
\title{Exporting tables for Juice}
\usage{
write_juice(data, file, formula, ...)

\S4method{write_juice}{vegtable,character,formula}(
  data,
  file,
  formula,
  FUN,
  db_name = "Plot Observations",
  header,
  coords,
  sep = ",",
  ...
)

read_juice(file, encoding = "LATIN-1", sep = ";", na = "", ...)
}
\arguments{
\item{data}{An object of class \linkS4class{vegtable}.}

\item{file}{Character value indicating the name of output files (without
file extension).}

\item{formula}{A formula passed to \code{\link[=crosstable]{crosstable()}}.}

\item{...}{Further arguments. While \code{write_juice()} passes them to the
function \code{\link[=crosstable]{crosstable()}}, \code{read_juice()} passes those arguments to
\code{\link[=readLines]{readLines()}}.}

\item{FUN}{Funtion passed to \code{\link[=crosstable]{crosstable()}}.}

\item{db_name}{Name for data set displayed in inport wizard.}

\item{header}{Variables of header to be exported.}

\item{coords}{Names of coordinate variables in header of \code{data}.}

\item{sep}{Separator used to split rows into columns.}

\item{encoding}{Argument passed to \code{\link{readLines}}.}

\item{na}{Character used as not available values.}
}
\value{
For \code{read_juice()}, a list with two elements: A data frame of species by
plot (\code{cross_table}), and a data frame with header data (\code{header}).
}
\description{
This function produce txt files as inport formats for \strong{Juice}
(\url{https://www.sci.muni.cz/botany/juice/}).

This function produces two output files to be imported into a \strong{Juice}
file: A vegetation table produced by \code{\link[=crosstable]{crosstable()}} and a header table.
Both tables share the file name plus a suffix (\code{table} for the
vegetation table and \code{header} for the header).

For the import in \strong{Juice}, you go to the menu
\verb{File -> Import -> Table -> from Spreadsheet File (e.g. EXCEL Table)} and
then follow the wizard.
Do not forget to select the proper settings in the wizard: 1) 'Character
delimiting columns: Comma' (for default argument values). 2) 'Use the second
column as layer information: Unchecked'. 3) 'Cover values: Percentage
Values'.

To further import the header table you need to go to the menu
\verb{File -> Import -> Header Data -> From Comma Delimited File}.

In the \code{header} (see \strong{Value}), the first column (\verb{Table number})
corresponds to the plot number assigned by \strong{Juice} at import, while
the column (\verb{Releve number}) is the number originally assigned to the plot
(e.g. \strong{Turboveg} ID).
}
\examples{
## Subset and transform cover values to percentage
vegetation <- Kenya_veg[1:20, ]
vegetation <- cover_trans(x = vegetation, to = "cover_percent", rule = "middle")

## Write in tempdir
write_juice(data = vegetation, file = file.path(tempdir(), "SWEA"),
    formula = cover_percent ~ ReleveID + AcceptedName, FUN = mean,
    header = c("ReleveID", "COMM_TYPE"))
## Installed 'Juice' version of 'Wetlands_veg'
Veg <- file.path(path.package("vegtable"), "juice", "Wetlands_juice.txt")
Veg <- read_juice(Veg)

summary(Veg)
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
