% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.cor.gen}
\alias{replicate.cor.gen}
\title{Compares and combines any type of correlation in original and
follow-up studies}
\usage{
replicate.cor.gen(alpha, cor1, se1, cor2, se2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor1}{estimated correlation in original study}

\item{se1}{standard error of correlation in original study}

\item{cor2}{estimated correlation in follow-up study}

\item{se2}{standard error of correlation in follow-up study}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the original study
\item Row 2 summarizes the follow-up study
\item Row 3 estimates the difference in correlations
\item Row 4 estimates the average correlation
}

The columns are:
\itemize{
\item Estimate - correlation estimate (single study, difference, average)
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function can be used to compare and combine any type of correlation
from an original study and a follow-up study. The confidence level for the
difference is 1 – 2*alpha, which is recommended for equivalence testing.
}
\examples{
replicate.cor.gen(.05, .454, .170, .318, .098)

# Should return:
#                       Estimate         SE         z            p          LL        UL
# Original:                0.454 0.17000000 2.2869806 0.0221969560  0.06991214 0.7208577
# Follow-up:               0.318 0.09800000 3.0215123 0.0025151541  0.11522137 0.4953353
# Original - Follow-up:    0.136 0.19622436 0.6671281 0.5046902807 -0.21543667 0.4237240
# Average:                 0.386 0.09811218 3.4089419 0.0006521538  0.19606750 0.5480170


}
\references{
\insertRef{Bonett2021}{vcmeta}
}
