% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cause_map.R
\name{cause_map}
\alias{cause_map}
\title{Broad Cause Mapping}
\usage{
cause_map(df, age_group)
}
\arguments{
\item{df}{Data frame. Outputs from \code{crossVA()} function in \code{openVA} for EAVA and \code{crossVA()} function in \code{openVA} for InSilicoVA and InterVA}

\item{age_group}{Character. The age group of interest. "neonate" for deaths between 0-27 days, and "child" for 1-59 months.}
}
\value{
Matrix. Rows are individuals. Columns are broad causes.
This is a binary matrix (entries 0 or 1) with 1 indicating the broad cause of death for the individual.
}
\description{
Maps individual-level specific (high resolution) cause of death (\code{codEAVA()} function
in \code{EAVA} and \code{crossVA()} function in \code{openVA}) to broad causes.
}
\examples{

## COMSA-Mozambique Publicly Available Version
## Example Individual-Level Specific (High-Resolution) Cause of Death Data
data(comsamoz_public_openVAout)
head(comsamoz_public_openVAout$data)  # head of the data
comsamoz_public_openVAout$data[1,]  # ID and specific cause of death for individual 1

## mapped to broad cause
## same as comsamoz_public_broad$data
comsamoz_public_asbroad = cause_map(df = comsamoz_public_openVAout$data, age_group = "neonate")
head(comsamoz_public_asbroad)

### store broad cause map of the data
data(comsamoz_public_broad)
head(comsamoz_public_broad$data) # identical to head(comsamoz_public_asbroad)

}
