% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/us-map.R
\name{us_map}
\alias{us_map}
\title{Retrieve US map data}
\usage{
us_map(
  regions = c("states", "state", "counties", "county"),
  include = c(),
  exclude = c(),
  data_year = NULL
)
}
\arguments{
\item{regions}{The region breakdown for the map, can be one of
(\code{"states"}, \code{"state"}, \code{"counties"}, \code{"county"}).
The default is \code{"states"}.}

\item{include}{The regions to include in the resulting map. If \code{regions} is
\code{"states"}/\code{"state"}, the value can be either a state name, abbreviation or FIPS code.
For counties, the FIPS must be provided as there can be multiple counties with the
same name. If states are provided in the county map, only counties in the included states
will be returned.}

\item{exclude}{The regions to exclude in the resulting map. If \code{regions} is
\code{"states"}/\code{"state"}, the value can be either a state name, abbreviation or FIPS code.
For counties, the FIPS must be provided as there can be multiple counties with the
same name. The regions listed in the \code{include} parameter take precedence over
regions listed in \code{exclude}. If both parameters include the same region(s) they
will be included in the map.}

\item{data_year}{The year for which to obtain map data.
If the value is \code{NULL}, the most recent year's data is used. If the
provided year is not found from the available map data sets, the next most
recent year's data is used. This can be used if an older data set is being
plotted on the US map so that the data matches the map more accurately.
Therefore, the provided value should match the year of the plotted data set.
The default is \code{NULL}, i.e. the most recent available year is used.}
}
\value{
An \code{sf} data frame of US map coordinates divided by the desired \code{regions}.
}
\description{
Retrieve US map data
}
\examples{
str(us_map())

df <- us_map(regions = "counties")
west_coast <- us_map(include = c("CA", "OR", "WA"))

excl_west_coast <- us_map(exclude = c("CA", "OR", "WA"))

ct_counties_as_of_2022 <- us_map(regions = "counties", include = "CT", data_year = 2022)

}
