% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbolic_units.R
\name{convert_to_base}
\alias{convert_to_base}
\title{Convert units to their base units}
\usage{
convert_to_base(x, simplify = TRUE, keep_fraction = TRUE)
}
\arguments{
\item{x}{object of class \code{units}.}

\item{simplify}{logical; if TRUE (default), the resulting units are simplified.}

\item{keep_fraction}{logical; if TRUE (default), the result is kept as a fraction.}
}
\value{
object of class \code{units} with units converted to base units.
}
\description{
Convert the units of a \code{units} object to their base units, as defined by
the udunits database (SI units).
}
\examples{
x <- set_units(32, mJ/g)
convert_to_base(x)
convert_to_base(x, keep_fraction=FALSE)
convert_to_base(x, simplify=FALSE)
convert_to_base(x, simplify=FALSE, keep_fraction=FALSE)
}
