% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UWaterloo.R
\docType{data}
\name{uwaterloo_environment}
\alias{uwaterloo_environment}
\title{Faculty of Environment colors of the University of Waterloo, Canada}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on the University of Waterloo's 
\href{https://uwaterloo.ca/}{Brand home}.
}
\usage{
uwaterloo_environment
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uwaterloo_environment} provides the four green color levels
of the \href{https://uwaterloo.ca}{University of Waterloo}, Canada.
}
\details{
Use the color Green to identify content and communications from the Faculty of Environment.

The 4 green colors are 
\code{"Green Level 1"} (digital) (defined as RGB: 218 245 130, HEX:	#DAF582),
\code{"Green Level 2"} (defined as CMYK: 23 0 89 0, RGB:	190 213 0, HEX:	#BED500),
\code{"Green Level 3"} (print primary color) (defined as CMYK: 24 0 98 8, RGB:	180 190 0, HEX:	#B4BE00), and
\code{"Green Level 4"} (digital primary color) (defined as RGB: 96 112 0, HEX:	#607000).

\code{uwaterloo_environment} uses the HEX color definitions.
}
\examples{
uwaterloo_environment
unikn::seecol(uwaterloo_environment, main = "Environment faculty colors of UWaterloo") 
# view color palette

}
\seealso{
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-29.
}
\concept{Canadian university color palettes}
\keyword{datasets}
