% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trinity_College_Dublin.R
\docType{data}
\name{trinity_1}
\alias{trinity_1}
\title{Primary colours of the Trinity College Dublin, Ireland}
\format{
An object of class \code{character} of length 12.
}
\source{
Color definitions are based on \href{https://www.tcd.ie}{TCD}'s 
\href{https://www.tcd.ie/identity/colour-palette/}{visual identity guidelines}.
}
\usage{
trinity_1
}
\value{
A names vector of colors (HEX/HTML codes of type character).
}
\description{
\code{trinity_1} provides the twelve primary colours
of the \href{https://www.tcd.ie}{Trinity College Dublin}, Ireland.
}
\details{
The 12 primary colours are 
\code{"Trinity blue"} (defined as HEX #0569b9), 
\code{"Trinity blue 75"} (defined as HEX #448fcb), 
\code{"Trinity blue 50"} (defined as HEX #82b4dc), 
\code{"Trinity blue 25"} (defined as HEX #cidaee), 
\code{"Trinity blue 10"} (defined as HEX #e6f0f8), 
\code{"grey 100"} (defined as HEX #50555a), 
\code{"grey 75"} (defined as HEX #7c8083), 
\code{"grey 50"} (defined as HEX #a8aaad), 
\code{"grey 25"} (defined as HEX #d3d5d6), 
\code{"grey 10"} (defined as HEX #eeeeef), 
\code{"white"} (defined as HEX #ffffff), and 
\code{"black"} (defined as HEX #000000).

\code{trinity_1} uses the HEX color definitions.


Colour provides a strong visual link to Trinity's visual identity across a wide range of applications. 

Trinity has a strong association with \code{Trinity blue} as the primary colour of its shield.

The colours of \code{trinity_1} (i.e., blue, grey and considered use of white space) are a crucial part of Trinity's visual identity. 

Applied consistently they provide an immediate and strong visual link throughout all communications.
}
\examples{
trinity_1
unikn::seecol(trinity_1, col_bg = "grey90",  
              main = "Primary colours of the Trinity College Dublin")  # view palette

}
\seealso{
\code{\link{trinity_2}} for secondary colors of Trinity College Dublin; 
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Irish university color palettes: 
\code{\link{galway_1}},
\code{\link{galway_2}},
\code{\link{limerick_1}},
\code{\link{limerick_2}},
\code{\link{maynooth}},
\code{\link{trinity_2}},
\code{\link{ucc_1}},
\code{\link{ucc_2}},
\code{\link{ucd}}
}
\author{
\strong{unicol}, 2023-07-16.
}
\concept{Irish university color palettes}
\keyword{datasets}
