% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JHU.R
\docType{data}
\name{jhu_2}
\alias{jhu_2}
\title{Secondary colors of Johns Hopkins University (JHU), USA}
\format{
An object of class \code{character} of length 6.
}
\source{
Color definitions are based on the
\href{https://brand.jhu.edu/color/}{Color manual}.
}
\usage{
jhu_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{jhu_2} provides the six secondary colors
of the \href{https://www.jhu.edu}{JHU, Johns Hopkins University}, USA.
}
\details{
The secondary color palette is designed to provide creative flexibility. 
These colors are complementary to the primary blues and were chosen to add warmth and energy to your design.

These secondary colors are
\code{"JHU red"} (defined as PMS 173 C, CMYK 0/82/94/2, RGB 207/69/32, HEX #CF4520),
\code{"JHU burgundy 1"} (defined as PMS 188 C, CMYK 16/100/65/58, RGB 118/35/47, HEX #76232F), 
\code{"JHU purple 1"} (defined as PMS 7655 C, CMYK 33/72/0/0, RGB 161/90/149, HEX #A15A95), 
\code{"JHU green 1"} (defined as PMS 3278 C, CMYK 99/0/69/0, RGB 0/155/119, HEX #009B77), 
\code{"JHU seablue"} (defined as PMS 285 C, CMYK 90/48/0/0, RGB 0/114/206, HEX #0072CE), and 
\code{"JHU yellow"} (defined as PMS 7406 C, CMYK 0/20/100/2, RGB 241/196/0, HEX #F1C400).
}
\examples{
jhu_2
unikn::seecol(jhu_2, main = "Accent colors of JHU") # view color palette

}
\seealso{
\code{\link{jhu_0}} for identity colors of JHU, Johns Hopkins University;
\code{\link{jhu_1}} for primary colors of JHU, Johns Hopkins University;
\code{\link{jhu_3_accent}} for accent colors of JHU, Johns Hopkins University;
\code{\link{jhu_4_gray}} for grey scale colors of JHU, Johns Hopkins University;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
