% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Glasgow.R
\docType{data}
\name{glasgow_2}
\alias{glasgow_2}
\title{Secondary colours of the University of Glasgow, Scotland}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on 
\href{https://www.gla.ac.uk/myglasgow/staff/brandtoolkit/brandelements/colours/}{UGlasgow's website}.
}
\usage{
glasgow_2
}
\value{
A named vector of colors (RGB/HTML codes of type character).
}
\description{
\code{glasgow_2} provides the five secondary colours 
of the \href{https://www.gla.ac.uk/}{University of Glasgow}, Scotland, UK.
}
\details{
The 5 secondary colours are 
\code{"Glasgow turquoise"} (defined as R0 G181 B209),
\code{"Glasgow rose"} (defined as R176 G108 B150),
\code{"Glasgow pumpkin"} (defined as R255 G185 B72),
\code{"Glasgow sunshine"} (defined as R255 G220 B54), and
\code{"Glasgow mocha"} (defined as R170 G128 B102).

\code{glasgow_2} uses the RGB colour definitions.
}
\examples{
glasgow_2
unikn::seecol(glasgow_2, main = "University of Glasgow 2") # view color palette

}
\seealso{
\code{\link{glasgow_1}} for primary colours of the University of Glasgow;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Scottish university of color palettes: 
\code{\link{glasgow_1}}
}
\author{
\strong{unicol}, 2023-07-05.
}
\concept{Scottish university of color palettes}
\keyword{datasets}
