% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMU.R
\docType{data}
\name{cmu_2}
\alias{cmu_2}
\title{Secondary colors of Carnegie Mellon University (CMU), USA}
\format{
An object of class \code{character} of length 6.
}
\source{
Color definitions are based on \href{https://www.cmu.edu}{CMU}'s
\href{https://www.cmu.edu/brand/brand-guidelines/visual-identity/colors.html}{Color manual}.
}
\usage{
cmu_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{cmu_2} provides six secondary (or Tartan) colors
of \href{https://www.cmu.edu}{Carnegie Mellon University (CMU)}, USA.
}
\details{
The so-called Tartan palette contains 6 secondary colors:
\code{"Scots rose"} (defined as CMYK 0/90/60/0, RGB R239/58/71, HEX #EF3A47),
\code{"gold thread"} (defined as CMYK 0/32/100/0, RGB R253/181/21, HEX #FDB515),
\code{"green thread"} (defined as CMYK 93/0/98/17, RGB R0/150/71, HEX #009647),
\code{"teal thread"} (defined as CMYK 100/0/29/24, RGB R0/143/145, HEX #008F91),
\code{"blue thread"} (defined as CMYK 100/75/6/24, RGB R4/54/115, HEX #043673), and 
\code{"Highlands sky blue"} (defined as CMYK 100/11/3/12, RGB R0/123/192, HEX #007BC0). 

\code{cmu_2} uses the HEX color definitions.


Use secondary colors as accents only to add energy or warmth to layouts 
as complements to the core palette.

When using a secondary color, \code{Carnegie red} (see \code{\link{cmu_1}}) 
must be present in the communication vehicle or product.
}
\examples{
cmu_2
unikn::seecol(cmu_2, main = "The secondary colors of CMU (Tartan palette)") # view palette

}
\seealso{
\code{\link{cmu_1}} for core colors of Carnegie Mellon University; 
\code{\link{cmu_3}} for campus colors of Carnegie Mellon University; 
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-16.
}
\concept{U.S. university color palettes}
\keyword{datasets}
