% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{txt_next}
\alias{txt_next}
\title{Get the n-th next element of a vector}
\usage{
txt_next(x, n = 1)
}
\arguments{
\item{x}{a character vector where each element is just 1 term or word}

\item{n}{an integer indicating how far to look next. Defaults to 1.}
}
\value{
a character vector of the same length of \code{x} with the next element
}
\description{
Get the n-th next element of a vector
}
\examples{
x <- sprintf("\%s\%s", LETTERS, 1:26)
txt_next(x, n = 1)

data.frame(word = x,
           word_next1 = txt_next(x, n = 1),
           word_next2 = txt_next(x, n = 2),
           stringsAsFactors = FALSE)
}
\seealso{
\code{\link[data.table]{shift}}
}
