% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{txt_context}
\alias{txt_context}
\title{Based on a vector with a word sequence, get n-grams (looking forward + backward)}
\usage{
txt_context(x, n = c(-1, 0, 1), sep = " ", na.rm = FALSE)
}
\arguments{
\item{x}{a character vector where each element is just 1 term or word}

\item{n}{an integer vector indicating how many terms to look back and ahead}

\item{sep}{a character element indicating how to \code{\link{paste}} the subsequent words together}

\item{na.rm}{logical, if set to \code{TRUE}, will keep all text even if it can not look back/ahead the amount specified by \code{n}. 
If set to \code{FALSE}, will have a resulting value of \code{NA}
if at least one element is \code{NA} or it can not look back/ahead the amount specified by \code{n}.}
}
\value{
a character vector of the same length of \code{x} with the n-grams
}
\description{
If you have annotated your text using \code{\link{udpipe_annotate}},
your text is tokenised in a sequence of words. Based on this vector of words in sequence
getting n-grams comes down to looking at the previous/next word and the subsequent previous/next word andsoforth.
These words can be \code{pasted} together to form an n-gram.
}
\examples{
x <- c("We", "walked", "anxiously", "to", "the", "doctor", "!")

## Look 1 word before + word itself
y <- txt_context(x, n = c(-1, 0), na.rm = FALSE)
data.frame(x, y)
## Look 1 word before + word itself + 1 word after
y <- txt_context(x, n = c(-1, 0, 1), na.rm = FALSE)
data.frame(x, y)
y <- txt_context(x, n = c(-1, 0, 1), na.rm = TRUE)
data.frame(x, y)

## Look 2 words before + word itself + 1 word after 
## even if not all words are there
y <- txt_context(x, n = c(-2, -1, 0, 1), na.rm = TRUE, sep = "_")
data.frame(x, y)
y <- txt_context(x, n = c(-2, -1, 1, 2), na.rm = FALSE, sep = "_")
data.frame(x, y)

x <- c("We", NA, NA, "to", "the", "doctor", "!")
y <- txt_context(x, n = c(-1, 0), na.rm = FALSE)
data.frame(x, y)
y <- txt_context(x, n = c(-1, 0), na.rm = TRUE)
data.frame(x, y)

library(data.table)
data(brussels_reviews_anno, package = "udpipe")
x      <- as.data.table(brussels_reviews_anno)
x      <- subset(x, doc_id \%in\% txt_sample(unique(x$doc_id), n = 10))
x      <- x[, context := txt_context(lemma), by = list(doc_id, sentence_id)]
head(x, 20)
x$term <- sprintf("\%s/\%s", x$lemma, x$upos)
x      <- x[, context := txt_context(term), by = list(doc_id, sentence_id)]
head(x, 20)
}
\seealso{
\code{\link{txt_paste}}, \code{\link{txt_next}}, \code{\link{txt_previous}}, \code{\link[data.table]{shift}}
}
