% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_phrase_sequences.R
\name{as_phrasemachine}
\alias{as_phrasemachine}
\title{Convert Parts of Speech tags to one-letter tags which can be used to identify phrases based on regular expressions}
\usage{
as_phrasemachine(x, type = c("upos", "penn-treebank"))
}
\arguments{
\item{x}{a character vector of POS tags for example by using \code{\link{udpipe_annotate}}}

\item{type}{either 'upos' or 'penn-treebank' indicating to recode Universal Parts of Speech tags to the counterparts
as described in the description, or to recode Parts of Speech tags as known in the Penn Treebank to the counterparts
as described in the description}
}
\value{
the character vector \code{x} where the respective POS tags are replaced with one-letter tags
}
\description{
Noun phrases are of common interest when doing natural language processing. Extracting noun phrases
from text can be done easily by defining a sequence of Parts of Speech tags. For example this sequence of POS tags
can be seen as a noun phrase: Adjective, Noun, Preposition, Noun.\cr
This function recodes Universal POS tags to one of the following 1-letter tags, in order to simplify writing regular expressions
to find Parts of Speech sequences:
\itemize{
\item A: adjective
\item C: coordinating conjuction
\item D: determiner
\item M: modifier of verb
\item N: noun or proper noun
\item P: preposition
\item O: other elements
}
After which identifying a simple noun phrase can be just expressed by using the following 
regular expression (A|N)*N(P+D*(A|N)*N)* which basically says
start with adjective or noun, another noun, a preposition, determiner adjective or noun and next a noun again.
}
\details{
For more information on extracting phrases see \url{http://brenocon.com/handler2016phrases.pdf}
}
\examples{
x <- c("PROPN", "SCONJ", "ADJ", "NOUN", "VERB", "INTJ", "DET", "VERB", 
       "PROPN", "AUX", "NUM", "NUM", "X", "SCONJ", "PRON", "PUNCT", "ADP", 
       "X", "PUNCT", "AUX", "PROPN", "ADP", "X", "PROPN", "ADP", "DET", 
       "CCONJ", "INTJ", "NOUN", "PROPN")
as_phrasemachine(x)
}
\seealso{
\code{\link{phrases}}
}
