% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict,ubmsFit-method}
\alias{posterior_predict,ubmsFit-method}
\alias{posterior_predict}
\title{Draw from the posterior predictive distribution}
\usage{
\S4method{posterior_predict}{ubmsFit}(
  object,
  param = c("y", "z"),
  draws = NULL,
  re.form = NULL,
  ...
)
}
\arguments{
\item{object}{A fitted model of class \code{ubmsFit}}

\item{param}{Either \code{"y"} for the observed outcome or \code{"z"}
for the unobserved latent state}

\item{draws}{An integer indicating the number of draws to return. The
default and maximum number of draws is the size of the posterior sample.}

\item{re.form}{If \code{NULL}, any estimated group-level parameters ("random
effects") are included. If \code{NA}, they are ignored}

\item{...}{Currently ignored}
}
\value{
A matrix of simulations from the posterior predictive distribution.
  If \code{param = "z"}, the dimensions are \code{draws} by number of sites
  (or sites x primary periods in site-major order for dynamic models). If
  \code{param = "y"}, the dimensions are \code{draws} by sites x observations
  (or sites x primary periods x observations for dynamic models).
}
\description{
Draw from the posterior predictive distribution after fitting a model.
You can draw from the posterior of the observed outcome \eqn{y} or
the latent unobserved state \eqn{z}.
}
