% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_metrics.R
\name{compute_metrics}
\alias{compute_metrics}
\alias{compute_metrics.default}
\alias{compute_metrics.tune_results}
\title{Calculate and format metrics from tuning functions}
\usage{
compute_metrics(x, metrics, summarize, event_level, ...)

\method{compute_metrics}{default}(x, metrics, summarize = TRUE, event_level = "first", ...)

\method{compute_metrics}{tune_results}(x, metrics, ..., summarize = TRUE, event_level = "first")
}
\arguments{
\item{x}{The results of a tuning function like \code{\link[=tune_grid]{tune_grid()}} or
\code{\link[=fit_resamples]{fit_resamples()}}, generated with the control option \code{save_pred = TRUE}.}

\item{metrics}{A \link[yardstick:metric_set]{metric set} of new metrics
to compute. See the "Details" section below for more information.}

\item{summarize}{A single logical value indicating whether metrics should
be summarized over resamples (\code{TRUE}) or return the values for each
individual resample. See \code{\link[=collect_metrics]{collect_metrics()}} for more details on how
metrics are summarized.}

\item{event_level}{A single string containing either \code{"first"} or \code{"second"}.
This argument is passed on to yardstick metric functions when any type
of class prediction is made, and specifies which level of the outcome
is considered the "event".}

\item{...}{Not currently used.}
}
\value{
A tibble. See \code{\link[=collect_metrics]{collect_metrics()}} for more details on the return value.
}
\description{
This function computes metrics from tuning results. The arguments and
output formats are closely related to those from \code{\link[=collect_metrics]{collect_metrics()}}, but
this function additionally takes a \code{metrics} argument with a
\link[yardstick:metric_set]{metric set} for new metrics to compute. This
allows for computing new performance metrics without requiring users to
re-evaluate models against resamples.

Note that the \link[=control_grid]{control option} \code{save_pred = TRUE} must
have been supplied when generating \code{x}.
}
\details{
Each metric in the set supplied to the \code{metrics} argument must have a metric
type (usually \code{"numeric"}, \code{"class"}, or \code{"prob"}) that matches some metric
evaluated when generating \code{x}. e.g. For example, if \code{x} was generated with
only hard \code{"class"} metrics, this function can't compute metrics that take in
class probabilities (\code{"prob"}.) By default, the tuning functions used to
generate \code{x} compute metrics of all needed types.
}
\examples{
\dontshow{if (tune:::should_run_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# load needed packages:
library(parsnip)
library(rsample)
library(yardstick)

# evaluate a linear regression against resamples.
# note that we pass `save_pred = TRUE`:
res <-
  fit_resamples(
    linear_reg(),
    mpg ~ cyl + hp,
    bootstraps(mtcars, 5),
    control = control_grid(save_pred = TRUE)
  )

# to return the metrics supplied to `fit_resamples()`:
collect_metrics(res)

# to compute new metrics:
compute_metrics(res, metric_set(mae))

# if `metrics` is the same as that passed to `fit_resamples()`,
# then `collect_metrics()` and `compute_metrics()` give the same
# output, though `compute_metrics()` is quite a bit slower:
all.equal(
  collect_metrics(res),
  compute_metrics(res, metric_set(rmse, rsq))
)
\dontshow{\}) # examplesIf}
}
