% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtest.R
\name{tsbacktest.tsissm.autospec}
\alias{tsbacktest.tsissm.autospec}
\alias{tsbacktest}
\alias{tsbacktest.tsissm.spec}
\title{Walk Forward Model Backtest}
\usage{
\method{tsbacktest}{tsissm.autospec}(
  object,
  start = floor(length(object$y)/2),
  end = length(object$y),
  h = 1,
  estimate_every = 1,
  rolling = FALSE,
  weights_scheme = c("AIC", "BIC", "U"),
  weights = NULL,
  seed = NULL,
  solver = "nloptr",
  control = NULL,
  trace = FALSE,
  ...
)

\method{tsbacktest}{tsissm.spec}(
  object,
  start = floor(length(object$target$y_orig)/2),
  end = length(object$target$y_orig),
  h = 1,
  estimate_every = 1,
  rolling = FALSE,
  seed = NULL,
  solver = "nloptr",
  control = NULL,
  trace = FALSE,
  ...
)
}
\arguments{
\item{object}{an object of class \dQuote{tsissm.spec} \dQuote{tsissm.autospec}.}

\item{start}{numeric data index from which to start the backtest.}

\item{end}{numeric data index on which to end the backtest. The backtest will
end 1 period before that date in order to have at least 1 out of sample value
to compare against.}

\item{h}{forecast horizon. As the expanding window approaches the \dQuote{end},
the horizon will automatically shrink to the number of available out of sample
periods.}

\item{estimate_every}{number of periods at which the model is re-estimated
and new predictions are generated (defaults to 1).}

\item{rolling}{this indicates whether forecasts are made only on the estimation
date (FALSE) or whether to filter the data 1 period at a time and forecast
from the filtered data (TRUE).}

\item{weights_scheme}{the weighting scheme to use when using ensembling (see note).}

\item{weights}{a vector of fixed user supplied weights of length \code{top_n} when choosing
\dQuote{U} in the \dQuote{weights_scheme}.}

\item{seed}{an value specifying if and how the random number generator should 
be initialized (\sQuote{seeded}). Either NULL or an integer that will be used in a 
call to set.seed before simulating the response vectors.}

\item{solver}{only \dQuote{nlortr} currently supported.}

\item{control}{optional control parameters.}

\item{trace}{whether to show the progress bar. The user is expected to have
set up appropriate handlers for this using the \dQuote{progressr} package.}

\item{...}{not used.}
}
\value{
A list with the following data.tables:
\itemize{
\item prediction : the backtest table with forecasts and actuals
\item metrics: a summary performance table showing metrics by
forecast horizon (MAPE, MSLRE, BIAS and MIS if alpha was not NULL).
}
}
\description{
Generates an expanding window walk forward backtest.
}
\note{
The function can use parallel functionality as long as the user has
set up a \code{\link[future]{plan}} using the future package. Model ensembling
is used when the input object is of class \dQuote{tsissm.autospec} and
top_n is greeter than 1. The following weighting schemes are available:
\describe{
  \item{U:}{User supplied fixed weights.}
  \item{AIC:}{Models are weighted based on their Akaike Information Criterion (AIC), 
        favoring models with lower AIC values. The weights are computed as:}
  \deqn{w_i = \frac{\exp(-0.5 \times \Delta_i)}{\sum_{j} \exp(-0.5 \times \Delta_j)}}
  where \deqn{\Delta_i = AIC_i - \min(AIC)}
  \item{BIC:}{Similar to AIC-based weighting but uses the Bayesian Information Criterion (BIC) 
        instead, which penalizes model complexity more strongly.}
}
The final ensemble prediction is computed as:
\deqn{\hat{y}_{\text{ensemble}} = \sum_{i} w_i \hat{y}_i}
where \eqn{w_i} are the model weights and \eqn{\hat{y}_i} are the individual model predictions.
AIC-based weighting is preferred when models have different complexities but are estimated on the same dataset, 
while BIC-based weighting may be better suited for large sample sizes due to its stronger penalty on complexity.
}
\seealso{
[tsensemble()]
}
