% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solvers.R
\name{issm_control}
\alias{issm_control}
\title{ISSM solver control parameters}
\usage{
issm_control(
  solver = "nloptr",
  algorithm = c("SLSQP", "AUGLAG/MMA", "AUGLAG/CCSAQ"),
  trace = 0,
  xtol_rel = 1e-14,
  maxeval = 1000,
  xtol_abs = 1e-12
)
}
\arguments{
\item{solver}{only \sQuote{nloptr} at present}

\item{algorithm}{(nloptr) the algorithm to use}

\item{trace}{(integer) controls print level information}

\item{xtol_rel}{(nloptr) relative tolerance on optimization parameters}

\item{maxeval}{(nloptr) number of function evaluations to stop on}

\item{xtol_abs}{(nloptr) absolute tolerances on optimization parameters}
}
\value{
a list with the options which is then passed to the solver.
}
\description{
ISSM solver control parameters
}
\details{
The function provides defaults for use, but additional control parameters may 
be appended to the list if the user so wishes (\sQuote{nloptr} has many more options).
}
