% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{extract}
\alias{extract}
\alias{.predict.sta}
\alias{.predict.sim}
\alias{.coef.sta}
\alias{.coef.sim}
\alias{.weights.sta}
\alias{.weights.sim}
\alias{.which.stack}
\title{Internal functions}
\usage{
.predict.sta(object, newx, ...)

.predict.sim(object, newx, ...)

.coef.sta(object, ...)

.coef.sim(object, ...)

.weights.sta(object, ...)

.weights.sim(object, ...)

.which.stack(object, stack)
}
\arguments{
\item{object}{object of class `transreg`}

\item{newx}{features:
matrix with \eqn{n} rows (samples) and \eqn{p} columns (variables)}

\item{...}{(not applicable)}

\item{stack}{character "sta" (standard stacking) or "sim" (simultaneous stacking)}
}
\description{
Internal functions called by
[coef.transreg()], [predict.transreg()] and [weights.transreg()], 
depending on choice between
standard stacking
and simultaneous stacking.
}
\section{Functions}{
\itemize{
\item \code{.predict.sta()}: called by `predict.transreg` if `stack="sta"`

\item \code{.predict.sim()}: called by `predict.transreg` if `stack="sim"`

\item \code{.coef.sta()}: called by `coef.transreg` if `stack="sta"`

\item \code{.coef.sim()}: called by `coef.transreg` if `stack="sim"`

\item \code{.weights.sta()}: called by `weights.transreg` if `stack="sta"`

\item \code{.weights.sim()}: called by `weights.transreg` if `stack="sim"`

\item \code{.which.stack()}: called by `coef.transreg`, `predict.transreg` and `weights.transreg`

}}
\seealso{
Use \code{\link[=coef.transreg]{coef}}, 
\code{\link[=predict.transreg]{predict}}
and \code{\link[=weights.transreg]{weights}}.
}
