% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search-better.r
\name{search_better_random}
\alias{search_better_random}
\title{Search for a better projection using simulated annealing}
\usage{
search_better_random(
  current,
  alpha = 0.5,
  index,
  tries,
  max.tries = Inf,
  method = "linear",
  cur_index = NA,
  t0 = 0.01,
  ...
)
}
\arguments{
\item{current}{starting projection}

\item{alpha}{the angle used to search the target basis from the current basis}

\item{index}{index function}

\item{tries}{the counter of the outer loop of the opotimiser}

\item{max.tries}{maximum number of iteration before giving up}

\item{method}{whether the nearby bases are found by a linear/ geodesic formulation}

\item{cur_index}{the index value of the current basis}

\item{t0}{initial decrease in temperature}

\item{...}{other arguments being passed into the \code{search_better_random()}}
}
\description{
Given an initial \eqn{t0}, the cooling scheme updates temperature at \deqn{T = t0 /\log(i + 1)}
The candidate basis is sampled via \deqn{B_j = (1 - \alpha) * B_i + \alpha * B} where alpha defines the neighbourhood, \eqn{B_i} is the current basis, B is a randomly generated basis
The acceptance probability is calculated as \deqn{prob = \exp{-abs(I(B_i) - I(B_j))/ T}}
For more information, see
\url{https://projecteuclid.org/download/pdf_1/euclid.ss/1177011077}
}
\examples{
animate_xy(flea[, 1:6], guided_tour(holes(), search_f = search_better_random))
}
\keyword{optimize}
