% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_pow}
\alias{torch_pow}
\title{Pow}
\usage{
torch_pow(self, exponent)
}
\arguments{
\item{self}{(float) the scalar base value for the power operation}

\item{exponent}{(float or tensor) the exponent value}
}
\description{
Pow
}
\section{pow(input, exponent, out=NULL) -> Tensor }{


Takes the power of each element in \code{input} with \code{exponent} and
returns a tensor with the result.

\code{exponent} can be either a single \code{float} number or a \code{Tensor}
with the same number of elements as \code{input}.

When \code{exponent} is a scalar value, the operation applied is:

\deqn{
    \mbox{out}_i = x_i^{\mbox{exponent}}
}
When \code{exponent} is a tensor, the operation applied is:

\deqn{
    \mbox{out}_i = x_i^{\mbox{exponent}_i}
}
When \code{exponent} is a tensor, the shapes of \code{input}
and \code{exponent} must be broadcastable .
}

\section{pow(self, exponent, out=NULL) -> Tensor }{


\code{self} is a scalar \code{float} value, and \code{exponent} is a tensor.
The returned tensor \code{out} is of the same shape as \code{exponent}

The operation applied is:

\deqn{
    \mbox{out}_i = \mbox{self} ^ {\mbox{exponent}_i}
}
}

\examples{
if (torch_is_installed()) {

a = torch_randn(c(4))
a
torch_pow(a, 2)
exp <- torch_arange(1, 5)
a <- torch_arange(1, 5)
a
exp
torch_pow(a, exp)


exp <- torch_arange(1, 5)
base <- 2
torch_pow(base, exp)
}
}
