% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{torch_get_rng_state}
\alias{torch_get_rng_state}
\alias{torch_set_rng_state}
\alias{cuda_get_rng_state}
\alias{cuda_set_rng_state}
\title{RNG state management}
\usage{
torch_get_rng_state()

torch_set_rng_state(state)

cuda_get_rng_state(device = NULL)

cuda_set_rng_state(state, device = NULL)
}
\arguments{
\item{state}{A tensor with the current state or a list containing the state
for each device - (for CUDA).}

\item{device}{The cuda device index to get or set the state. If \code{NULL} gets the state
for all available devices.}
}
\description{
Low level functionality to set and change the RNG state.
It's recommended to use \code{\link[=torch_manual_seed]{torch_manual_seed()}} for most cases.
}
\section{Functions}{
\itemize{
\item \code{torch_set_rng_state()}: Sets the RNG state for the CPU

\item \code{cuda_get_rng_state()}: Gets the RNG state for CUDA.

\item \code{cuda_set_rng_state()}: Sets the RNG state for CUDA.

}}
