% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_flatten}
\alias{torch_flatten}
\title{Flatten}
\usage{
torch_flatten(self, dims, start_dim = 1L, end_dim = -1L, out_dim)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dims}{if tensor is named you can pass the name of the dimensions to
flatten}

\item{start_dim}{(int) the first dim to flatten}

\item{end_dim}{(int) the last dim to flatten}

\item{out_dim}{the name of the resulting dimension if a named tensor.}
}
\description{
Flatten
}
\section{flatten(input, start_dim=0, end_dim=-1) -> Tensor }{


Flattens a contiguous range of dims in a tensor.
}

\examples{
if (torch_is_installed()) {

t = torch_tensor(matrix(c(1, 2), ncol = 2))
torch_flatten(t)
torch_flatten(t, start_dim=2)
}
}
