% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_bernoulli}
\alias{torch_bernoulli}
\title{Bernoulli}
\usage{
torch_bernoulli(self, p, generator = NULL)
}
\arguments{
\item{self}{(Tensor) the input tensor of probability values for the Bernoulli
distribution}

\item{p}{(Number) a probability value. If \code{p} is passed than it's used instead of
the values in \code{self} tensor.}

\item{generator}{(\code{torch.Generator}, optional) a pseudorandom number generator for sampling}
}
\description{
Bernoulli
}
\section{bernoulli(input, *, generator=NULL, out=NULL) -> Tensor }{


Draws binary random numbers (0 or 1) from a Bernoulli distribution.

The \code{input} tensor should be a tensor containing probabilities
to be used for drawing the binary random number.
Hence, all values in \code{input} have to be in the range:
\eqn{0 \leq \mbox{input}_i \leq 1}.

The \eqn{\mbox{i}^{th}} element of the output tensor will draw a
value \eqn{1} according to the \eqn{\mbox{i}^{th}} probability value given
in \code{input}.

\deqn{
    \mbox{out}_{i} \sim \mathrm{Bernoulli}(p = \mbox{input}_{i})
}
The returned \code{out} tensor only has values 0 or 1 and is of the same
shape as \code{input}.

\code{out} can have integral \code{dtype}, but \code{input} must have floating
point \code{dtype}.
}

\examples{
if (torch_is_installed()) {

a = torch_empty(c(3, 3))$uniform_(0, 1)  # generate a uniform random matrix with range c(0, 1)
a
torch_bernoulli(a)
a = torch_ones(c(3, 3)) # probability of drawing "1" is 1
torch_bernoulli(a)
a = torch_zeros(c(3, 3)) # probability of drawing "1" is 0
torch_bernoulli(a)
}
}
