% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnf-pooling.R
\name{nnf_avg_pool3d}
\alias{nnf_avg_pool3d}
\title{Avg_pool3d}
\usage{
nnf_avg_pool3d(
  input,
  kernel_size,
  stride = NULL,
  padding = 0,
  ceil_mode = FALSE,
  count_include_pad = TRUE,
  divisor_override = NULL
)
}
\arguments{
\item{input}{input tensor (minibatch, in_channels , iT * iH , iW)}

\item{kernel_size}{size of the pooling region. Can be a single number or a
tuple \verb{(kT, kH, kW)}}

\item{stride}{stride of the pooling operation. Can be a single number or a
tuple \verb{(sT, sH, sW)}. Default: \code{kernel_size}}

\item{padding}{implicit zero paddings on both sides of the input. Can be a
single number or a tuple \verb{(padT, padH, padW)}, Default: 0}

\item{ceil_mode}{when True, will use \code{ceil} instead of \code{floor} in the formula
to compute the output shape}

\item{count_include_pad}{when True, will include the zero-padding in the
averaging calculation}

\item{divisor_override}{NA if specified, it will be used as divisor, otherwise
size of the pooling region will be used. Default: \code{NULL}}
}
\description{
Applies 3D average-pooling operation in \eqn{kT * kH * kW} regions by step
size \eqn{sT * sH * sW} steps. The number of output features is equal to
\eqn{\lfloor \frac{ \mbox{input planes} }{sT} \rfloor}.
}
