% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-pooling.R
\name{nn_max_unpool1d}
\alias{nn_max_unpool1d}
\title{Computes a partial inverse of \code{MaxPool1d}.}
\usage{
nn_max_unpool1d(kernel_size, stride = NULL, padding = 0)
}
\arguments{
\item{kernel_size}{(int or tuple): Size of the max pooling window.}

\item{stride}{(int or tuple): Stride of the max pooling window.
It is set to \code{kernel_size} by default.}

\item{padding}{(int or tuple): Padding that was added to the input}
}
\description{
\code{MaxPool1d} is not fully invertible, since the non-maximal values are lost.
\code{MaxUnpool1d} takes in as input the output of \code{MaxPool1d}
including the indices of the maximal values and computes a partial inverse
in which all non-maximal values are set to zero.
}
\note{
\code{MaxPool1d} can map several input sizes to the same output
sizes. Hence, the inversion process can get ambiguous.
To accommodate this, you can provide the needed output size
as an additional argument \code{output_size} in the forward call.
See the Inputs and Example below.
}
\section{Inputs}{

\itemize{
\item \code{input}: the input Tensor to invert
\item \code{indices}: the indices given out by \code{\link[=nn_max_pool1d]{nn_max_pool1d()}}
\item \code{output_size} (optional): the targeted output size
}
}

\section{Shape}{

\itemize{
\item Input: \eqn{(N, C, H_{in})}
\item Output: \eqn{(N, C, H_{out})}, where
\deqn{
  H_{out} = (H_{in} - 1) \times \mbox{stride}[0] - 2 \times \mbox{padding}[0] + \mbox{kernel\_size}[0]
}
or as given by \code{output_size} in the call operator
}
}

\examples{
if (torch_is_installed()) {
pool <- nn_max_pool1d(2, stride = 2, return_indices = TRUE)
unpool <- nn_max_unpool1d(2, stride = 2)

input <- torch_tensor(array(1:8 / 1, dim = c(1, 1, 8)))
out <- pool(input)
unpool(out[[1]], out[[2]])

# Example showcasing the use of output_size
input <- torch_tensor(array(1:8 / 1, dim = c(1, 1, 8)))
out <- pool(input)
unpool(out[[1]], out[[2]], output_size = input$size())
unpool(out[[1]], out[[2]])
}
}
