% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-activation.R
\name{nn_celu}
\alias{nn_celu}
\title{CELU module}
\usage{
nn_celu(alpha = 1, inplace = FALSE)
}
\arguments{
\item{alpha}{the \eqn{\alpha} value for the CELU formulation. Default: 1.0}

\item{inplace}{can optionally do the operation in-place. Default: \code{FALSE}}
}
\description{
Applies the element-wise function:
}
\details{
\deqn{
  \mbox{CELU}(x) = \max(0,x) + \min(0, \alpha * (\exp(x/\alpha) - 1))
}

More details can be found in the paper
\href{https://arxiv.org/abs/1704.07483}{Continuously Differentiable Exponential Linear Units}.
}
\section{Shape}{

\itemize{
\item Input: \eqn{(N, *)} where \code{*} means, any number of additional
dimensions
\item Output: \eqn{(N, *)}, same shape as the input
}
}

\examples{
if (torch_is_installed()) {
m <- nn_celu()
input <- torch_randn(2)
output <- m(input)
}
}
