% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autograd.R
\name{autograd_grad}
\alias{autograd_grad}
\title{Computes and returns the sum of gradients of outputs w.r.t. the inputs.}
\usage{
autograd_grad(
  outputs,
  inputs,
  grad_outputs = NULL,
  retain_graph = create_graph,
  create_graph = FALSE,
  allow_unused = FALSE
)
}
\arguments{
\item{outputs}{(sequence of Tensor) – outputs of the differentiated function.}

\item{inputs}{(sequence of Tensor) – Inputs w.r.t. which the gradient will be
returned (and not accumulated into .grad).}

\item{grad_outputs}{(sequence of Tensor) – The “vector” in the Jacobian-vector
product. Usually gradients w.r.t. each output. None values can be specified for
scalar Tensors or ones that don’t require grad. If a None value would be acceptable
for all \code{grad_tensors}, then this argument is optional. Default: None.}

\item{retain_graph}{(bool, optional) – If \code{FALSE}, the graph used to compute the
grad will be freed. Note that in nearly all cases setting this option to \code{TRUE} is
not needed and often can be worked around in a much more efficient way.
Defaults to the value of \code{create_graph}.}

\item{create_graph}{(bool, optional) – If \verb{TRUE, graph of the derivative will be constructed, allowing to compute higher order derivative products. Default: }FALSE`.}

\item{allow_unused}{(bool, optional) – If \code{FALSE}, specifying inputs that were
not used when computing outputs (and therefore their grad is always zero) is an
error. Defaults to \code{FALSE}}
}
\description{
\code{grad_outputs} should be a list of length matching output containing the “vector”
in Jacobian-vector product, usually the pre-computed gradients w.r.t. each of
the outputs. If an output doesn’t require_grad, then the gradient can be None).
}
\details{
If only_inputs is \code{TRUE}, the function will only return a list of gradients w.r.t
the specified inputs. If it’s \code{FALSE}, then gradient w.r.t. all remaining leaves
will still be computed, and will be accumulated into their \code{.grad} attribute.
}
\examples{
if (torch_is_installed()) {
w <- torch_tensor(0.5, requires_grad = TRUE)
b <- torch_tensor(0.9, requires_grad = TRUE)
x <- torch_tensor(runif(100))
y <- 2 * x + 1
loss <- (y - (w * x + b))^2
loss <- loss$mean()

o <- autograd_grad(loss, list(w, b))
o
}
}
