% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ignite.R
\name{OptimizerIgnite}
\alias{OptimizerIgnite}
\title{Abstract Base Class for LibTorch Optimizers}
\description{
Abstract base class for wrapping LibTorch C++ optimizers.
}
\section{Super class}{
\code{torch::torch_optimizer} -> \code{OptimizerIgnite}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimizerIgnite-new}{\code{OptimizerIgnite$new()}}
\item \href{#method-OptimizerIgnite-state_dict}{\code{OptimizerIgnite$state_dict()}}
\item \href{#method-OptimizerIgnite-load_state_dict}{\code{OptimizerIgnite$load_state_dict()}}
\item \href{#method-OptimizerIgnite-step}{\code{OptimizerIgnite$step()}}
\item \href{#method-OptimizerIgnite-zero_grad}{\code{OptimizerIgnite$zero_grad()}}
\item \href{#method-OptimizerIgnite-add_param_group}{\code{OptimizerIgnite$add_param_group()}}
\item \href{#method-OptimizerIgnite-clone}{\code{OptimizerIgnite$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerIgnite-new"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerIgnite-new}{}}}
\subsection{Method \code{new()}}{
Initializes the optimizer with the specified parameters and defaults.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerIgnite$new(params, defaults)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{(\code{list()})\cr
Either a list of tensors or a list of parameter groups, each containing the \code{params} to optimizer
as well as the optimizer options such as the learning rate, weight decay, etc.}

\item{\code{defaults}}{(\code{list()})\cr
A list of default optimizer options.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerIgnite-state_dict"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerIgnite-state_dict}{}}}
\subsection{Method \code{state_dict()}}{
Returns the state dictionary containing the current state of the optimizer.
The returned \code{list()} contains two lists:
\itemize{
\item \code{param_groups}: The parameter groups of the optimizer (\code{lr}, ...) as well as to which
parameters they are applied (\code{params}, integer indices)
\item \code{state}: The states of the optimizer. The names are the indices of the parameters to which
they belong, converted to character.
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerIgnite$state_dict()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{list()})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerIgnite-load_state_dict"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerIgnite-load_state_dict}{}}}
\subsection{Method \code{load_state_dict()}}{
Loads the state dictionary into the optimizer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerIgnite$load_state_dict(state_dict)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state_dict}}{(\code{list()})\cr
The state dictionary to load into the optimizer.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerIgnite-step"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerIgnite-step}{}}}
\subsection{Method \code{step()}}{
Performs a single optimization step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerIgnite$step(closure = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{closure}}{(\verb{function()})\cr
A closure that conducts the forward pass and returns the loss.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
(\code{numeric()})\cr
The loss.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerIgnite-zero_grad"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerIgnite-zero_grad}{}}}
\subsection{Method \code{zero_grad()}}{
Zeros out the gradients of the parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerIgnite$zero_grad()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerIgnite-add_param_group"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerIgnite-add_param_group}{}}}
\subsection{Method \code{add_param_group()}}{
Adds a new parameter group to the optimizer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerIgnite$add_param_group(param_group)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_group}}{(\code{list()})\cr
A parameter group to add to the optimizer.
This should contain the \code{params} to optimize as well as the optimizer options.
For all options that are not specified, the defaults are used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerIgnite-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerIgnite-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerIgnite$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
