% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.tna_bootstrap}
\alias{print.tna_bootstrap}
\title{Print Bootstrap Results}
\usage{
\method{print}{tna_bootstrap}(x, digits = getOption("digits"), type = "both", ...)
}
\arguments{
\item{x}{A \code{tna_bootstrap} object.}

\item{digits}{An \code{integer} giving the minimal number of
\emph{significant} digits to print.}

\item{type}{A \code{character} vector giving the type of edges to print.
The default option \code{"both"} prints both statistically significant and
non-significant edges, \code{"sig"} prints only significant edges, and \code{"nonsig"}
prints only the non-significant edges.}

\item{...}{Ignored.}
}
\value{
\code{x} (invisibly).
}
\description{
Print Bootstrap Results
}
\examples{
model <- tna(group_regulation)
# Small number of iterations for CRAN
boot <- bootstrap(model, iter = 10)
print(boot)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
