% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_eof_ram.R
\name{make_eof_ram}
\alias{make_eof_ram}
\title{Make a RAM (Reticular Action Model)}
\usage{
make_eof_ram(
  times,
  variables,
  n_eof,
  remove_na = TRUE,
  standard_deviations = "unequal"
)
}
\arguments{
\item{times}{A character vector listing the set of times in order}

\item{variables}{A character vector listing the set of variables}

\item{n_eof}{Number of EOF modes of variability to estimate}

\item{remove_na}{Boolean indicating whether to remove NA values from RAM (default) or not.
\code{remove_NA=FALSE} might be useful for exploration and diagnostics for
advanced users}

\item{standard_deviations}{One of \code{"equal"}, \code{"unequal"}, or a numeric vector
indicating fixed values.}
}
\value{
A reticular action module (RAM) describing dependencies
}
\description{
\code{make_eof_ram} converts SEM arrow notation to \code{ram} describing SEM parameters
}
\examples{
# Two EOFs for two variables
make_eof_ram( times = 2010:2020, variables = c("pollock","cod"), n_eof=2 )

}
