% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxent_params.R
\name{maxent_params}
\alias{maxent_params}
\alias{regularization_multiplier}
\alias{feature_classes}
\title{Parameters for maxent models}
\usage{
regularization_multiplier(range = c(0.5, 3), trans = NULL)

feature_classes(values = c("l", "lq", "lqp", "lqph", "lqpht"))
}
\arguments{
\item{range}{A two-element vector holding the defaults for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the transformed units.}

\item{trans}{A trans object from the scales package, such as
scales::log10_trans() or scales::reciprocal_trans(). If not provided, the
default is used which matches the units used in range. If no
transformation, NULL.}

\item{values}{For \code{feature_classes()}, a character string of any subset of
"lqpht" (for example, "lh")}
}
\value{
a \code{param} object that can be used for tuning.
}
\description{
These parameters are auxiliary to MaxEnt models using the "maxnet" engine.
These functions are used by the tuning functions, and the user will rarely
access them directly.
}
\examples{
regularization_multiplier()
feature_classes()
}
