% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q_matrix.R
\name{q_matrix}
\alias{q_matrix}
\title{Convert a standard matrix to a \code{q_matrix} object}
\usage{
q_matrix(x)
}
\arguments{
\item{x}{A matrix or a data frame}
}
\value{
A \code{q_matrix} object
}
\description{
Takes a single Q matrix that exists as either a matrix or a data frame and
returns a \code{q_matrix} object.
}
\examples{
# Read in a single .Q file
q_mat <- read.table(system.file("extdata", "anolis", "anolis_ld_run1.3.Q",
  package = "tidypopgen"
))
class(q_mat)

# Convert to a Q matrix object
q_mat <- q_matrix(q_mat)
class(q_mat)

}
