% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_admix_methods.R
\name{gt_admix_reorder_q}
\alias{gt_admix_reorder_q}
\title{Reorder the q matrices based on the grouping variable}
\usage{
gt_admix_reorder_q(x, group = NULL)
}
\arguments{
\item{x}{a \code{gt_admix} object, possibly with a grouping variable}

\item{group}{a character vector with the grouping variable (if there is no
grouping variable info in \code{x})}
}
\value{
a \code{gt_admix} object with the q matrices reordered
}
\description{
This function reorders the q matrices in a \code{gt_admix} object based on the
grouping variable. This is useful before plotting when the samples from each
group are not adjacent to each other in the q matrix.
}
\examples{
# run the example only if we have the package installed
if (requireNamespace("LEA", quietly = TRUE)) {
  example_gt <- load_example_gt("gen_tbl")

  # Create a gt_admix object
  admix_obj <- example_gt \%>\% gt_snmf(k = 1:3, project = "force")

  # The $id in admix_obj is the same as in the gen_tibble
  admix_obj$id

  # Reorder the q matrices based on the grouping variable
  admix_obj <- gt_admix_reorder_q(admix_obj,
    group = example_gt$population
  )

  # The $id in admix_obj is now reordered according to the population
  admix_obj$id
}

}
